function [fusion_times, VSout, time] = directMethod_SingleSyt_Casignal3(VS0, par, Casignal, evalVes, steadyIO)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%                                                                                 %%%
%%%               This code was written to be used in our publication               %%%
%%%             "Allosteric stabilization of calcium and lipid binding              %%%
%%%                    three synaptotagmins in fast exocytosis"                     %%% 
%%%                          Kobbersmed et al., Journal Year                        %%%
%%%                           DOI:  XX.XXXX/XXXX.XXXXXXXXXX                         %%%
%%%                                                                                 %%%
%%%             When reusing this code in a publication, in original or             %%%
%%%                       modified form, please cite our work.                      %%%
%%%                                                                                 %%%
%%%                                     Authors:                                    %%%
%%%                   Janus R. L. Kobbersmed (januslind@math.ku.dk)                 %%%
%%%                    Manon M.M. Berns (manon.berns@sund.ku.dk)                    %%%
%%%                    Alexander M. Walter (awalter@sund.ku.dk)                     %%%
%%%         Department of neuroscience, University of Copenhagen, Denmark           %%%
%%%                                    October 2021                                 %%%
%%%                                                                                 %%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


%This function computes vesicle fusion times following the gillespie
%algorithm. It does not include the option to simulate heterozygous mutant
%expression or to assess variability in syt number. 

%VS0 - steady state matrix
%par - model parameters (see list below)
%Casignal - matrix with Ca2+ transient and the corresponding time
%evalVes - number of vesicle fusions to evaluate
%SteadyIO - 1 run to test if steady state is reached. 

%Fusion_times - Fusion time points of SVs
%VSout - Final state of the synaptotagmins
%time - Timesteps taken.


% Initialize
MAX_OUTPUT_LENGTH = 1e7;
%samplingrate = 22e3;
n=size(VS0,1); %no Syts
ves=size(VS0,2); %no ves.
T = 0;

%numEval = 50;

VSout = VS0;

k_onCa = par(1);
KD = par(2);
k_onPIP2 = par(3);
PIP2 = par(4);
c = par(5);
l = par(6);
f = par(7);
nsyt = par(8);
maxcross = par(9);
cacoop = par(10);
maxCa = par(11);
KD_pip = par(12);


Time_ca = Casignal(:,1);
Calcium = Casignal(:,2);
CaIP = Calcium(1);

alpha = CaIP^cacoop * k_onCa;
beta = KD*k_onCa;
gamma = PIP2 * k_onPIP2;
delta = KD_pip*k_onPIP2; %%% ops: KD for PIP2 different than for Ca2+!!!

transitions = [1, 10, -1, -10];
fusion_times = NaN(evalVes, 1);
%fusion_times = NaN(evalVes, 1);
rxn_count = 1; %Reaction counter
fused_ves = 0;%fusion_count = 0;
X= NaN(evalVes, 15);

%count_states = NaN(5e6, 1);
%count_states(1,1) = sum(sum(VSout==0));
%count_states(1,2) = sum(sum(VSout==1));
%count_states(1,3) = sum(sum(VSout==10));
%count_states(1,1) = sum(sum(VSout==11)>=3);
%count_states(1,5) =0;
time = 0;

%if DN_IO == 1
%    c1 = c;
%    beta_m = beta;
%    alpha_m = 0; 
%elseif DN_IO ==2
%    c1 = 0.5;
%    beta_m = beta*10;
%    alpha_m = alpha;
%else 
%    c1 =1;
%    beta_m = beta;
%    alpha_m = 0;
%end

%% MAIN LOOP


%because Ca does not change in these stimuli, the rates can be determied
%beforehand
VSin=VSout;
PIPbound = repmat(sum(VSin==11 | VSin==1,1), nsyt, 1);

%if varNsytIO
%   % r = randi([nsyt-4,nsyt], 1,ves);
%    b = repmat([1:nsyt]',1,ves);     
%    z= b<=varNsytIO;
%    x = z==1 & b<=maxCa;
%    y = z==1 &b>maxCa;
%else 
   % z = ones(nsyt, ves);
   % x = [ones(maxCa, ves); zeros(nsyt-maxCa, ves)];
   % y = [zeros(maxCa, ves); ones(nsyt-maxCa, ves)];
%end

%if maxCross_var
%    maxcross = maxCross_var;
%else
%
%maxcross = ones(1, ves)*maxcross;
%end
%tic;

a_1 = (VSin==0).*((max(maxcross-PIPbound,0)).*gamma+alpha) + (VSin==1).*(alpha+delta) + (VSin==10).*(beta+(max(maxcross-PIPbound,0)).*gamma) + (VSin==11).*(delta*c+beta*c);
%a_1 = z.*((VSin==0).*((max(maxcross-PIPbound,0)).*gamma) + (VSin==1).*(delta.*x) + (VSin==10).*(beta+(max(maxcross-PIPbound,0)).*gamma) + (VSin==11).*(delta*c+beta*c)...
%+((VSin==0)+(VSin ==1)).*alpha.*x + (VSin  ==1).*(delta.*y *c1)) ;

%a_1 = ((VSin==0).*((max(maxcross-PIPbound,0)).*gamma) + (VSin==1).*(delta.*x) + (VSin==10).*(beta*x+(max(maxcross-PIPbound,0)).*gamma) + (VSin==11).*(delta*c+beta*c*x)...
%+((VSin==0)+(VSin ==1)).*alpha.*x + (VSin  ==1).*(delta *c1)) + ((VSin==0)+(VSin ==1)).*alpha_m.*y  + beta_m *y.*((VSin==11)*c + (VSin == 10));
a_2 = l.*f.^sum((VSin==11),1);


%a_2 = l.*f.^(VSin==11);
a = vertcat(a_1,a_2);
a0 = sum(sum(a,1));

while ((rxn_count < 1e4 && steadyIO == 1)||(T < Time_ca(end) && steadyIO ==0))
   % Calculate reaction propensities
    VSin=VSout;
    
    if a0 > 0 %Make sure there are still releaseable vesicles    
        r = rand(1,4);
        tau = (1/a0)*log(1/r(1));
        
        if tau > 8e-6
        T= T+8e-6;
        else
        ves_ind  = find((cumsum(sum(a,1)) >= r(2)*a0),1,'first'); % Determine vesicle number

         %%%%%%Carry out reaction
        %determine reaction of vesicle
        syt_ind = find((cumsum(a(:,ves_ind)) >= r(3)*sum(a(:,ves_ind))),1,'first'); % Determine reaction number;
        if syt_ind == n+1
            fused_ves = fused_ves+1;
            fusion_times(fused_ves)=T;
            X(fused_ves,:) = VSin(:,ves_ind)';
            VSout=VSin;
            VSout(:,ves_ind)=-1;
%             a(:, ves_ind) =0;   %vesicle does not participate in fusion any more
%             a0=sum(sum(a));
           
            
        else
            %if syt_ind<=maxCa
                
                a_react = [(1-mod(VSin(syt_ind,ves_ind),10))*gamma*max(maxcross - PIPbound(syt_ind, ves_ind),0),...
                    (1-floor(VSin(syt_ind,ves_ind)/10))*alpha, mod(VSin(syt_ind,ves_ind),10)*delta*c^floor(VSin(syt_ind,ves_ind)/10), ...
                    floor(VSin(syt_ind,ves_ind)/10)*beta*c^mod(VSin(syt_ind,ves_ind),10)];
           
                reaction_type = find((cumsum(a_react) >= r(4)*sum(a_react)),1,'first'); % Determine reaction number;
            
                VSout=VSin;
            
                VSout(syt_ind,ves_ind) = VSin(syt_ind,ves_ind)+transitions(reaction_type); % carry out reaction
            
            %else
                
                %a_react = [(1-mod(VSin(syt_ind,ves_ind),10))*gamma*max(maxcross(ves_ind) - PIPbound(syt_ind, ves_ind),0), 0, mod(VSin(syt_ind,ves_ind),10)*delta*c^floor(VSin(syt_ind,ves_ind)/10), floor(VSin(syt_ind,ves_ind)/10)*beta*c^mod(VSin(syt_ind,ves_ind),10)];
                
                %a_react = [(1-mod(VSin(syt_ind,ves_ind),10))*gamma*max(maxcross - PIPbound(syt_ind, ves_ind),0),...
                %    (1-floor(VSin(syt_ind,ves_ind)/10))*alpha_m, mod(VSin(syt_ind,ves_ind),10)*delta*c^floor(VSin(syt_ind,ves_ind)/10)*c1^(VSin(syt_ind,ves_ind)==1),...
                %    floor(VSin(syt_ind,ves_ind)/10)*beta_m*c^mod(VSin(syt_ind,ves_ind),10)];
           
               % reaction_type = find((cumsum(a_react) >= r(4)*sum(a_react)),1,'first'); % Determine reaction number;
            
                %VSout=VSin;
            
                VSout(syt_ind,ves_ind) = VSin(syt_ind,ves_ind)+transitions(reaction_type); % carry out reaction
            %end
            %update a-Matrix
            PIPbound(:, ves_ind) = repmat(sum(VSout(:, ves_ind)==11 | VSout(:, ves_ind)==1,1), nsyt, 1);
            
%                 a(1:n,ves_ind) = z(:,ves_ind).*((VSout(:,ves_ind)==0).*(gamma*max(maxcross(ves_ind) - PIPbound(:, ves_ind),0)) ...
%                 + (VSout(:,ves_ind)==1).*(delta).*x(:,1) + (VSout(:,ves_ind)==1).*(delta).*y(:,1)*c ...
%                 + (VSout(:,ves_ind)==10).*(beta+gamma*max(maxcross(ves_ind) - PIPbound(:, ves_ind),0)) ...
%                 + (VSout(:,ves_ind)==11).*(delta*c+beta*c)...
%                 +((VSout(:, ves_ind)==0)+(VSout(:,ves_ind) ==1)).*alpha.*x(:,1));
% 
%             a(n+1,ves_ind)=l*f^sum((VSout(:,ves_ind)==11).*z(:,ves_ind),1);
%            
%             a0=sum(sum(a));
            
        end
        T   = T  + tau;
        rxn_count = rxn_count + 1;
        end
        ca = interp1(Time_ca , Calcium, T);
        alpha = ca^cacoop * k_onCa;
        
        a(1:n, :) = ((VSout==0).*((max(maxcross-PIPbound,0)).*gamma) + (VSout==1).*(delta) + ...
            (VSout==10).*(beta+(max(maxcross-PIPbound,0)).*gamma) + (VSout==11).*(delta*c+beta*c)...
        +((VSout==0)+(VSout ==1)).*alpha) ;
    
        %a(1:n, :) = ((VSout==0).*(gamma.*max(maxcross- PIPbound, 0)) ...
        %       + (VSout ==1).*(delta.*x) +  (VSout==1).*(delta.*y*c1)  ...
        %       + (VSout ==10).*(beta*x+gamma*max(maxcross - PIPbound, 0)) ... 
        %       + (VSout ==11).*(delta*c+beta*c*x)...
        %       + ((VSout== 0) + (VSout ==1)).*alpha.*x ...
        %       + ((VSout==0) + (VSout==1)).*alpha_m.*y ...
        %       + ((VSout==11).*c + (VSout== 10)).*beta_m.*y);
    
        a(n+1,:) = l.*f.^sum((VSin==11),1);
        a0= sum(sum(a));
        
        time = [time, T];
        
        %count_states(rxn_count,1) = sum(sum(VSout==0));
        %count_states(rxn_count,2) = sum(sum(VSout==1));
        %count_states(rxn_count,3) = sum(sum(VSout==10));
       % count_states = [count_states,sum(sum(VSout==11)>=3)];
        %count_states(rxn_count,5) =T;
      
     else %If all R-vesicles have fused
        %T   = tspan(2);
        VSout = VSin;
        rxn_count = rxn_count + 1;
    end
end


%toc
